<?php

namespace Tests\Feature;

use App\Models\Outlet;
use App\Models\Product;
use App\Models\Register;
use App\Models\User;
use App\Models\VariantOption;
use App\Models\ProductVariant;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Illuminate\Support\Str;
use Tests\TestCase;

class CreatePaidOrderTest extends TestCase
{
    use RefreshDatabase;

    public function test_cashier_can_create_paid_order_online(): void
    {
        $outlet = Outlet::query()->create(['name' => 'Outlet A', 'timezone' => 'Asia/Jakarta']);
        $register = Register::query()->create(['outlet_id' => $outlet->id, 'name' => 'Kasir 1']);
        $user = User::factory()->create(['outlet_id' => $outlet->id, 'role' => 'cashier']);

        $product = Product::query()->create([
            'outlet_id' => $outlet->id,
            'name' => 'Latte',
            'sku' => 'LATTE-1',
            'base_price' => 20000,
            'is_active' => true,
        ]);

        $group = ProductVariant::query()->create([
            'product_id' => $product->id,
            'name' => 'Size',
            'is_required' => false,
            'max_selection' => 1,
        ]);

        $option = VariantOption::query()->create([
            'product_variant_id' => $group->id,
            'name' => 'Large',
            'price_delta' => 5000,
        ]);

        $this->actingAs($user)->postJson('/pos/orders', [
            'client_order_id' => (string) Str::uuid(),
            'register_id' => $register->id,
            'order_type' => 'dine-in',
            'table_number' => 'A1',
            'discount' => 0,
            'items' => [
                [
                    'product_id' => $product->id,
                    'qty' => 1,
                    'variant_option_id' => $option->id,
                    'addon_ids' => [],
                ],
            ],
            'payments' => [
                ['method' => 'CASH', 'amount' => 29000],
            ],
        ])->assertOk()->assertJsonPath('status', 'PAID');

        $this->assertDatabaseCount('orders', 1);
        $this->assertDatabaseCount('order_items', 1);
        $this->assertDatabaseHas('orders', ['status' => 'PAID']);
    }
}
