<?php if (isset($component)) { $__componentOriginal5863877a5171c196453bfa0bd807e410 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal5863877a5171c196453bfa0bd807e410 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.layouts.app','data' => ['title' => 'Edit '.$product->name]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('layouts.app'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute('Edit '.$product->name)]); ?>
    <div class="space-y-4">
        <section class="rounded-xl border border-slate-200 bg-white p-4">
            <h1 class="mb-3 text-lg font-semibold">Edit Produk: <?php echo e($product->name); ?></h1>
            <form method="POST" action="<?php echo e(route('master.products.update', $product)); ?>" enctype="multipart/form-data" class="grid gap-2 md:grid-cols-2">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <input name="name" value="<?php echo e($product->name); ?>" required class="rounded border px-3 py-2">
                <input name="sku" value="<?php echo e($product->sku); ?>" required class="rounded border px-3 py-2">
                <select name="category_id" class="rounded border px-3 py-2">
                    <option value="">- Kategori -</option>
                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($cat->id); ?>" <?php if($product->category_id === $cat->id): echo 'selected'; endif; ?>><?php echo e($cat->name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <input name="base_price" type="number" value="<?php echo e($product->base_price); ?>" required class="rounded border px-3 py-2">
                <input name="cost" type="number" value="<?php echo e($product->cost); ?>" class="rounded border px-3 py-2">
                <input name="image_file" type="file" accept="image/*" class="rounded border px-3 py-2">
                <input name="image_url" value="<?php echo e($product->image_url); ?>" class="rounded border px-3 py-2">
                <div class="md:col-span-2">
                    <img src="<?php echo e($product->image_url ?: '/icons/icon-192.svg'); ?>" alt="" class="h-24 w-24 rounded-xl object-cover">
                </div>
                <label class="inline-flex items-center gap-2 md:col-span-2">
                    <input type="checkbox" name="is_active" value="1" <?php if($product->is_active): echo 'checked'; endif; ?>>
                    <span>Aktif</span>
                </label>
                <div class="md:col-span-2">
                    <button class="rounded bg-slate-900 px-3 py-2 text-sm text-white">Update Produk</button>
                </div>
            </form>
            <form method="POST" action="<?php echo e(route('master.products.destroy', $product)); ?>" class="mt-2">
                <?php echo csrf_field(); ?>
                <?php echo method_field('DELETE'); ?>
                <button onclick="return confirm('Hapus produk?')" class="rounded bg-rose-600 px-3 py-2 text-sm text-white">Hapus Produk</button>
            </form>
        </section>

        <div class="grid gap-4 lg:grid-cols-2">
            <section class="rounded-xl border border-slate-200 bg-white p-4">
                <h2 class="mb-3 text-lg font-semibold">Variant Group & Options</h2>
                <form method="POST" action="<?php echo e(route('master.variants.store', $product)); ?>" class="mb-4 grid grid-cols-4 gap-2 text-sm">
                    <?php echo csrf_field(); ?>
                    <input name="name" required placeholder="Nama group (Size)" class="col-span-2 rounded border px-2 py-2">
                    <input name="max_selection" type="number" value="1" class="rounded border px-2 py-2">
                    <label class="inline-flex items-center gap-2 rounded border px-2">
                        <input type="checkbox" name="is_required" value="1">
                        Required
                    </label>
                    <button class="col-span-4 rounded bg-slate-900 px-3 py-2 text-white">Tambah Group</button>
                </form>

                <div class="space-y-3">
                    <?php $__currentLoopData = $product->variants; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $variant): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="rounded border p-3">
                            <form method="POST" action="<?php echo e(route('master.variants.update', $variant)); ?>" class="grid grid-cols-4 gap-2 text-sm">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('PUT'); ?>
                                <input name="name" value="<?php echo e($variant->name); ?>" class="col-span-2 rounded border px-2 py-1">
                                <input name="max_selection" type="number" value="<?php echo e($variant->max_selection); ?>" class="rounded border px-2 py-1">
                                <label class="inline-flex items-center gap-2 rounded border px-2">
                                    <input type="checkbox" name="is_required" value="1" <?php if($variant->is_required): echo 'checked'; endif; ?>>
                                    Required
                                </label>
                                <button class="rounded bg-slate-900 px-2 py-1 text-xs text-white">Update Group</button>
                            </form>
                            <form method="POST" action="<?php echo e(route('master.variants.destroy', $variant)); ?>" class="mt-2">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button onclick="return confirm('Hapus group variant?')" class="rounded bg-rose-600 px-2 py-1 text-xs text-white">Hapus Group</button>
                            </form>

                            <div class="mt-2 space-y-1">
                                <?php $__currentLoopData = $variant->options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="grid grid-cols-2 gap-2 text-sm">
                                        <form method="POST" action="<?php echo e(route('master.variant-options.update', $option)); ?>" class="grid grid-cols-2 gap-2">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('PUT'); ?>
                                            <input name="name" value="<?php echo e($option->name); ?>" class="rounded border px-2 py-1">
                                            <input name="price_delta" type="number" value="<?php echo e($option->price_delta); ?>" class="rounded border px-2 py-1">
                                            <button class="col-span-2 rounded bg-slate-800 px-2 py-1 text-xs text-white">Update Option</button>
                                        </form>
                                        <form method="POST" action="<?php echo e(route('master.variant-options.destroy', $option)); ?>">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button onclick="return confirm('Hapus option?')" class="rounded bg-rose-600 px-2 py-1 text-xs text-white">Hapus Option</button>
                                        </form>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>

                            <form method="POST" action="<?php echo e(route('master.variant-options.store', $variant)); ?>" class="mt-2 grid grid-cols-3 gap-2 text-sm">
                                <?php echo csrf_field(); ?>
                                <input name="name" required placeholder="Nama option" class="rounded border px-2 py-1">
                                <input name="price_delta" type="number" value="0" class="rounded border px-2 py-1">
                                <button class="rounded bg-emerald-600 px-2 py-1 text-xs text-white">Tambah Option</button>
                            </form>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </section>

            <section class="rounded-xl border border-slate-200 bg-white p-4">
                <h2 class="mb-3 text-lg font-semibold">Add-ons</h2>
                <form method="POST" action="<?php echo e(route('master.addons.store', $product)); ?>" class="mb-4 grid grid-cols-3 gap-2 text-sm">
                    <?php echo csrf_field(); ?>
                    <input name="name" required placeholder="Nama add-on" class="rounded border px-2 py-2">
                    <input name="price" type="number" required placeholder="Harga" class="rounded border px-2 py-2">
                    <button class="rounded bg-slate-900 px-2 py-2 text-white">Tambah Add-on</button>
                </form>

                <div class="space-y-2">
                    <?php $__currentLoopData = $product->addons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $addon): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="rounded border p-2">
                            <form method="POST" action="<?php echo e(route('master.addons.update', $addon)); ?>" class="grid grid-cols-3 gap-2 text-sm">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('PUT'); ?>
                                <input name="name" value="<?php echo e($addon->name); ?>" class="rounded border px-2 py-1">
                                <input name="price" type="number" value="<?php echo e($addon->price); ?>" class="rounded border px-2 py-1">
                                <button class="rounded bg-slate-800 px-2 py-1 text-xs text-white">Update</button>
                            </form>
                            <form method="POST" action="<?php echo e(route('master.addons.destroy', $addon)); ?>" class="mt-1">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button onclick="return confirm('Hapus add-on?')" class="rounded bg-rose-600 px-2 py-1 text-xs text-white">Hapus</button>
                            </form>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </section>
        </div>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal5863877a5171c196453bfa0bd807e410)): ?>
<?php $attributes = $__attributesOriginal5863877a5171c196453bfa0bd807e410; ?>
<?php unset($__attributesOriginal5863877a5171c196453bfa0bd807e410); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal5863877a5171c196453bfa0bd807e410)): ?>
<?php $component = $__componentOriginal5863877a5171c196453bfa0bd807e410; ?>
<?php unset($__componentOriginal5863877a5171c196453bfa0bd807e410); ?>
<?php endif; ?>
<?php /**PATH C:\Users\IPI ACD\Documents\WORKSPACE\kasir\resources\views/master/products/edit.blade.php ENDPATH**/ ?>