<?php if (isset($component)) { $__componentOriginal5863877a5171c196453bfa0bd807e410 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal5863877a5171c196453bfa0bd807e410 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.layouts.app','data' => ['title' => 'Order '.$order->receipt_number]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('layouts.app'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute('Order '.$order->receipt_number)]); ?>
    <div class="grid gap-4 lg:grid-cols-2">
        <section class="rounded-xl border border-slate-200 bg-white p-4">
            <h1 class="mb-2 text-lg font-semibold">Order <?php echo e($order->receipt_number); ?></h1>
            <p class="text-sm text-slate-500">Status: <?php echo e($order->status); ?></p>
            <div class="mt-3 space-y-2 text-sm">
                <?php $__currentLoopData = $order->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="flex items-center justify-between border-b pb-1">
                        <span><?php echo e($item->name_snapshot); ?> x<?php echo e($item->qty); ?></span>
                        <span>Rp <?php echo e(number_format($item->line_total, 0, ',', '.')); ?></span>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
            <div class="mt-4 space-y-1 text-sm">
                <div class="flex justify-between"><span>Subtotal</span><span>Rp <?php echo e(number_format($order->subtotal, 0, ',', '.')); ?></span></div>
                <div class="flex justify-between"><span>Tax</span><span>Rp <?php echo e(number_format($order->tax, 0, ',', '.')); ?></span></div>
                <div class="flex justify-between"><span>Service</span><span>Rp <?php echo e(number_format($order->service, 0, ',', '.')); ?></span></div>
                <div class="flex justify-between font-semibold"><span>Total</span><span>Rp <?php echo e(number_format($order->total, 0, ',', '.')); ?></span></div>
            </div>

            <div class="mt-4 flex gap-2">
                <a href="<?php echo e(route('orders.print', $order)); ?>" target="_blank" class="rounded bg-slate-900 px-3 py-2 text-sm text-white">Print Thermal Receipt</a>
                <?php if(in_array(auth()->user()->role, ['owner','admin'], true) && $order->status === 'PAID'): ?>
                    <form method="POST" action="<?php echo e(route('orders.void', $order)); ?>" class="flex gap-2">
                        <?php echo csrf_field(); ?>
                        <input name="reason" required placeholder="Alasan void" class="rounded border px-2 py-1 text-sm">
                        <button class="rounded bg-rose-600 px-3 py-2 text-sm text-white">Void</button>
                    </form>
                <?php endif; ?>
            </div>
        </section>

        <section class="rounded-xl border border-slate-200 bg-white p-4 print:block">
            <h2 class="mb-2 text-lg font-semibold">Template Receipt</h2>
            <p class="text-sm"><?php echo e($order->outlet->receipt_header); ?></p>
            <hr class="my-2">
            <?php $__currentLoopData = $order->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="flex justify-between text-sm">
                    <span><?php echo e($item->name_snapshot); ?> x<?php echo e($item->qty); ?></span>
                    <span><?php echo e(number_format($item->line_total, 0, ',', '.')); ?></span>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <hr class="my-2">
            <div class="flex justify-between text-sm font-semibold">
                <span>Total</span>
                <span><?php echo e(number_format($order->total, 0, ',', '.')); ?></span>
            </div>
            <p class="mt-3 text-xs"><?php echo e($order->outlet->receipt_footer); ?></p>
        </section>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal5863877a5171c196453bfa0bd807e410)): ?>
<?php $attributes = $__attributesOriginal5863877a5171c196453bfa0bd807e410; ?>
<?php unset($__attributesOriginal5863877a5171c196453bfa0bd807e410); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal5863877a5171c196453bfa0bd807e410)): ?>
<?php $component = $__componentOriginal5863877a5171c196453bfa0bd807e410; ?>
<?php unset($__componentOriginal5863877a5171c196453bfa0bd807e410); ?>
<?php endif; ?>
<?php /**PATH C:\Users\IPI ACD\Documents\WORKSPACE\kasir\resources\views/orders/show.blade.php ENDPATH**/ ?>