<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Receipt <?php echo e($order->receipt_number); ?></title>
    <style>
        @page { size: 80mm auto; margin: 3mm; }
        body { font-family: "Courier New", monospace; width: 72mm; margin: 0 auto; color: #111; font-size: 12px; }
        .center { text-align: center; }
        .row { display: flex; justify-content: space-between; gap: 8px; }
        .line { border-top: 1px dashed #111; margin: 6px 0; }
        .muted { color: #555; }
        .total { font-weight: 700; font-size: 13px; }
    </style>
</head>
<body onload="window.print()">
    <div class="center">
        <div><strong><?php echo e($order->outlet->name); ?></strong></div>
        <?php if($order->outlet->address): ?><div class="muted"><?php echo e($order->outlet->address); ?></div><?php endif; ?>
        <?php if($order->outlet->receipt_header): ?><div><?php echo e($order->outlet->receipt_header); ?></div><?php endif; ?>
    </div>

    <div class="line"></div>
    <div class="row"><span>No</span><span><?php echo e($order->receipt_number); ?></span></div>
    <div class="row"><span>Kasir</span><span>#<?php echo e($order->user_id); ?></span></div>
    <div class="row"><span>Tanggal</span><span><?php echo e($order->created_at->format('d/m/Y H:i')); ?></span></div>
    <div class="line"></div>

    <?php $__currentLoopData = $order->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div><?php echo e($item->name_snapshot); ?></div>
        <div class="row muted">
            <span><?php echo e($item->qty); ?> x <?php echo e(number_format($item->base_price, 0, ',', '.')); ?></span>
            <span><?php echo e(number_format($item->line_total, 0, ',', '.')); ?></span>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    <div class="line"></div>
    <div class="row"><span>Subtotal</span><span><?php echo e(number_format($order->subtotal, 0, ',', '.')); ?></span></div>
    <div class="row"><span>Diskon</span><span><?php echo e(number_format($order->discount, 0, ',', '.')); ?></span></div>
    <div class="row"><span>Pajak</span><span><?php echo e(number_format($order->tax, 0, ',', '.')); ?></span></div>
    <div class="row"><span>Service</span><span><?php echo e(number_format($order->service, 0, ',', '.')); ?></span></div>
    <div class="row total"><span>Total</span><span><?php echo e(number_format($order->total, 0, ',', '.')); ?></span></div>

    <div class="line"></div>
    <?php $__currentLoopData = $order->payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="row"><span><?php echo e($payment->method); ?></span><span><?php echo e(number_format($payment->amount, 0, ',', '.')); ?></span></div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <div class="line"></div>

    <div class="center muted">
        <?php if($order->outlet->receipt_footer): ?>
            <?php echo e($order->outlet->receipt_footer); ?>

        <?php else: ?>
            Terima kasih.
        <?php endif; ?>
    </div>
</body>
</html>
<?php /**PATH C:\Users\IPI ACD\Documents\WORKSPACE\kasir\resources\views/orders/print.blade.php ENDPATH**/ ?>