<?php if (isset($component)) { $__componentOriginal5863877a5171c196453bfa0bd807e410 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal5863877a5171c196453bfa0bd807e410 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.layouts.app','data' => ['title' => 'Shifts']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('layouts.app'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Shifts']); ?>
    <div class="grid gap-4 lg:grid-cols-3">
        <section class="rounded-xl border border-slate-200 bg-white p-4">
            <h2 class="mb-3 text-lg font-semibold">Buka Shift</h2>
            <form method="POST" action="<?php echo e(route('shifts.open')); ?>" class="space-y-2 text-sm">
                <?php echo csrf_field(); ?>
                <label class="block">Register ID
                    <input name="register_id" type="number" class="mt-1 w-full rounded border px-2 py-2">
                </label>
                <label class="block">Opening Cash
                    <input name="opening_cash" type="number" class="mt-1 w-full rounded border px-2 py-2">
                </label>
                <button class="rounded bg-slate-900 px-3 py-2 text-white">Open</button>
            </form>
        </section>

        <section class="rounded-xl border border-slate-200 bg-white p-4">
            <h2 class="mb-3 text-lg font-semibold">Cash In/Out</h2>
            <form method="POST" action="<?php echo e(route('shifts.move')); ?>" class="space-y-2 text-sm">
                <?php echo csrf_field(); ?>
                <input name="shift_id" type="number" placeholder="Shift ID" class="w-full rounded border px-2 py-2">
                <select name="type" class="w-full rounded border px-2 py-2">
                    <option value="IN">IN</option>
                    <option value="OUT">OUT</option>
                </select>
                <input name="amount" type="number" placeholder="Amount" class="w-full rounded border px-2 py-2">
                <input name="note" placeholder="Note" class="w-full rounded border px-2 py-2">
                <button class="rounded bg-slate-900 px-3 py-2 text-white">Save</button>
            </form>
        </section>

        <section class="rounded-xl border border-slate-200 bg-white p-4">
            <h2 class="mb-3 text-lg font-semibold">Tutup Shift</h2>
            <form method="POST" action="#" class="space-y-2 text-sm" onsubmit="event.preventDefault(); const id=this.shift_id.value; this.action='/shifts/'+id+'/close'; this.submit();">
                <?php echo csrf_field(); ?>
                <input name="shift_id" type="number" placeholder="Shift ID" class="w-full rounded border px-2 py-2">
                <input name="closing_cash" type="number" placeholder="Closing Cash" class="w-full rounded border px-2 py-2">
                <button class="rounded bg-slate-900 px-3 py-2 text-white">Close</button>
            </form>
        </section>
    </div>

    <div class="mt-4 rounded-xl border border-slate-200 bg-white p-4">
        <h2 class="mb-3 text-lg font-semibold">Riwayat Shift</h2>
        <div class="overflow-auto">
            <table class="min-w-full text-sm">
                <thead class="bg-slate-50 text-left">
                <tr>
                    <th class="px-2 py-2">ID</th>
                    <th class="px-2 py-2">Register</th>
                    <th class="px-2 py-2">Open</th>
                    <th class="px-2 py-2">Close</th>
                    <th class="px-2 py-2">Expected</th>
                    <th class="px-2 py-2">Variance</th>
                </tr>
                </thead>
                <tbody>
                <?php $__currentLoopData = $shifts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $shift): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr class="border-t">
                        <td class="px-2 py-2"><?php echo e($shift->id); ?></td>
                        <td class="px-2 py-2"><?php echo e($shift->register?->name); ?></td>
                        <td class="px-2 py-2"><?php echo e($shift->opening_cash); ?></td>
                        <td class="px-2 py-2"><?php echo e($shift->closing_cash ?? '-'); ?></td>
                        <td class="px-2 py-2"><?php echo e($shift->expected_cash ?? '-'); ?></td>
                        <td class="px-2 py-2"><?php echo e($shift->variance ?? '-'); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
        <div class="mt-3"><?php echo e($shifts->links()); ?></div>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal5863877a5171c196453bfa0bd807e410)): ?>
<?php $attributes = $__attributesOriginal5863877a5171c196453bfa0bd807e410; ?>
<?php unset($__attributesOriginal5863877a5171c196453bfa0bd807e410); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal5863877a5171c196453bfa0bd807e410)): ?>
<?php $component = $__componentOriginal5863877a5171c196453bfa0bd807e410; ?>
<?php unset($__componentOriginal5863877a5171c196453bfa0bd807e410); ?>
<?php endif; ?>
<?php /**PATH C:\Users\IPI ACD\Documents\WORKSPACE\kasir\resources\views/shifts/index.blade.php ENDPATH**/ ?>