<?php

use App\Http\Controllers\AuthController;
use App\Http\Controllers\CategoryController;
use App\Http\Controllers\CustomerMenuController;
use App\Http\Controllers\KdsController;
use App\Http\Controllers\OfflineQueueController;
use App\Http\Controllers\OrderController;
use App\Http\Controllers\PosController;
use App\Http\Controllers\ProductAddonController;
use App\Http\Controllers\ProductController;
use App\Http\Controllers\ProductVariantController;
use App\Http\Controllers\ReportController;
use App\Http\Controllers\SettingController;
use App\Http\Controllers\ShiftController;
use App\Http\Controllers\TableController;
use Illuminate\Support\Facades\Route;

Route::redirect('/', '/pos');

// Public self-order routes (no auth required)
Route::get('/menu/{token}', [CustomerMenuController::class, 'show'])->name('customer.menu');
Route::post('/menu/{token}/order', [CustomerMenuController::class, 'store'])->name('customer.order.store');
Route::get('/menu/{token}/order/{order}/status', [CustomerMenuController::class, 'status'])->name('customer.order.status');

Route::middleware('guest')->group(function () {
    Route::get('/login', [AuthController::class, 'create'])->name('login');
    Route::post('/login', [AuthController::class, 'store'])->name('login.store');
});

Route::middleware('auth')->group(function () {
    Route::post('/logout', [AuthController::class, 'destroy'])->name('logout');

    Route::get('/pos', [PosController::class, 'index'])->name('pos.index');
    Route::post('/pos/orders', [PosController::class, 'store'])->name('pos.orders.store');

    Route::get('/orders', [OrderController::class, 'index'])->name('orders.index');
    Route::get('/orders/{order}', [OrderController::class, 'show'])->name('orders.show');
    Route::get('/orders/{order}/print', [OrderController::class, 'print'])->name('orders.print');
    Route::post('/orders/{order}/void', [OrderController::class, 'void'])
        ->middleware('role:owner,admin')
        ->name('orders.void');
    Route::post('/orders/{order}/refund', [OrderController::class, 'refund'])
        ->middleware('role:owner,admin')
        ->name('orders.refund');

    Route::get('/shifts', [ShiftController::class, 'index'])->name('shifts.index');
    Route::post('/shifts/open', [ShiftController::class, 'open'])->name('shifts.open');
    Route::post('/shifts/move', [ShiftController::class, 'move'])->name('shifts.move');
    Route::post('/shifts/{shift}/close', [ShiftController::class, 'close'])->name('shifts.close');

    Route::get('/reports', [ReportController::class, 'index'])
        ->middleware('role:owner,admin')
        ->name('reports.index');
    Route::get('/kds', [KdsController::class, 'index'])
        ->middleware('role:owner,admin')
        ->name('kds.index');
    Route::post('/kds/{order}/status', [KdsController::class, 'update'])
        ->middleware('role:owner,admin')
        ->name('kds.update');

    Route::get('/settings', [SettingController::class, 'index'])
        ->middleware('role:owner,admin')
        ->name('settings.index');
    Route::post('/settings', [SettingController::class, 'update'])
        ->middleware('role:owner,admin')
        ->name('settings.update');

    Route::get('/offline-queue', [OfflineQueueController::class, 'index'])
        ->middleware('role:owner,admin')
        ->name('offline-queue.index');

    Route::middleware('role:owner,admin')->prefix('master')->name('master.')->group(function () {
        Route::get('/categories', [CategoryController::class, 'index'])->name('categories.index');
        Route::post('/categories', [CategoryController::class, 'store'])->name('categories.store');
        Route::put('/categories/{category}', [CategoryController::class, 'update'])->name('categories.update');
        Route::delete('/categories/{category}', [CategoryController::class, 'destroy'])->name('categories.destroy');

        Route::get('/products', [ProductController::class, 'index'])->name('products.index');
        Route::post('/products', [ProductController::class, 'store'])->name('products.store');
        Route::get('/products/{product}/edit', [ProductController::class, 'edit'])->name('products.edit');
        Route::put('/products/{product}', [ProductController::class, 'update'])->name('products.update');
        Route::delete('/products/{product}', [ProductController::class, 'destroy'])->name('products.destroy');

        Route::post('/products/{product}/variants', [ProductVariantController::class, 'store'])->name('variants.store');
        Route::put('/variants/{variant}', [ProductVariantController::class, 'update'])->name('variants.update');
        Route::delete('/variants/{variant}', [ProductVariantController::class, 'destroy'])->name('variants.destroy');
        Route::post('/variants/{variant}/options', [ProductVariantController::class, 'storeOption'])->name('variant-options.store');
        Route::put('/variant-options/{option}', [ProductVariantController::class, 'updateOption'])->name('variant-options.update');
        Route::delete('/variant-options/{option}', [ProductVariantController::class, 'destroyOption'])->name('variant-options.destroy');

        Route::post('/products/{product}/addons', [ProductAddonController::class, 'store'])->name('addons.store');
        Route::put('/addons/{addon}', [ProductAddonController::class, 'update'])->name('addons.update');
        Route::delete('/addons/{addon}', [ProductAddonController::class, 'destroy'])->name('addons.destroy');

        Route::get('/tables', [TableController::class, 'index'])->name('tables.index');
        Route::post('/tables', [TableController::class, 'store'])->name('tables.store');
        Route::put('/tables/{table}', [TableController::class, 'update'])->name('tables.update');
        Route::delete('/tables/{table}', [TableController::class, 'destroy'])->name('tables.destroy');
    });
});
