<x-layouts.app title="Shifts">
    <div class="grid gap-4 lg:grid-cols-3">
        <section class="rounded-xl border border-slate-200 bg-white p-4">
            <h2 class="mb-3 text-lg font-semibold">Buka Shift</h2>
            <form method="POST" action="{{ route('shifts.open') }}" class="space-y-2 text-sm">
                @csrf
                <label class="block">Register ID
                    <input name="register_id" type="number" class="mt-1 w-full rounded border px-2 py-2">
                </label>
                <label class="block">Opening Cash
                    <input name="opening_cash" type="number" class="mt-1 w-full rounded border px-2 py-2">
                </label>
                <button class="rounded bg-slate-900 px-3 py-2 text-white">Open</button>
            </form>
        </section>

        <section class="rounded-xl border border-slate-200 bg-white p-4">
            <h2 class="mb-3 text-lg font-semibold">Cash In/Out</h2>
            <form method="POST" action="{{ route('shifts.move') }}" class="space-y-2 text-sm">
                @csrf
                <input name="shift_id" type="number" placeholder="Shift ID" class="w-full rounded border px-2 py-2">
                <select name="type" class="w-full rounded border px-2 py-2">
                    <option value="IN">IN</option>
                    <option value="OUT">OUT</option>
                </select>
                <input name="amount" type="number" placeholder="Amount" class="w-full rounded border px-2 py-2">
                <input name="note" placeholder="Note" class="w-full rounded border px-2 py-2">
                <button class="rounded bg-slate-900 px-3 py-2 text-white">Save</button>
            </form>
        </section>

        <section class="rounded-xl border border-slate-200 bg-white p-4">
            <h2 class="mb-3 text-lg font-semibold">Tutup Shift</h2>
            <form method="POST" action="#" class="space-y-2 text-sm" onsubmit="event.preventDefault(); const id=this.shift_id.value; this.action='/shifts/'+id+'/close'; this.submit();">
                @csrf
                <input name="shift_id" type="number" placeholder="Shift ID" class="w-full rounded border px-2 py-2">
                <input name="closing_cash" type="number" placeholder="Closing Cash" class="w-full rounded border px-2 py-2">
                <button class="rounded bg-slate-900 px-3 py-2 text-white">Close</button>
            </form>
        </section>
    </div>

    <div class="mt-4 rounded-xl border border-slate-200 bg-white p-4">
        <h2 class="mb-3 text-lg font-semibold">Riwayat Shift</h2>
        <div class="overflow-auto">
            <table class="min-w-full text-sm">
                <thead class="bg-slate-50 text-left">
                <tr>
                    <th class="px-2 py-2">ID</th>
                    <th class="px-2 py-2">Register</th>
                    <th class="px-2 py-2">Open</th>
                    <th class="px-2 py-2">Close</th>
                    <th class="px-2 py-2">Expected</th>
                    <th class="px-2 py-2">Variance</th>
                </tr>
                </thead>
                <tbody>
                @foreach($shifts as $shift)
                    <tr class="border-t">
                        <td class="px-2 py-2">{{ $shift->id }}</td>
                        <td class="px-2 py-2">{{ $shift->register?->name }}</td>
                        <td class="px-2 py-2">{{ $shift->opening_cash }}</td>
                        <td class="px-2 py-2">{{ $shift->closing_cash ?? '-' }}</td>
                        <td class="px-2 py-2">{{ $shift->expected_cash ?? '-' }}</td>
                        <td class="px-2 py-2">{{ $shift->variance ?? '-' }}</td>
                    </tr>
                @endforeach
                </tbody>
            </table>
        </div>
        <div class="mt-3">{{ $shifts->links() }}</div>
    </div>
</x-layouts.app>
