<x-layouts.app title="Settings">
    <div class="rounded-xl border border-slate-200 bg-white p-4">
        <h1 class="mb-4 text-lg font-semibold">Pengaturan Outlet</h1>
        <form method="POST" action="{{ route('settings.update') }}" class="grid gap-3 md:grid-cols-2">
            @csrf
            <label class="text-sm">Nama
                <input name="name" value="{{ old('name', $outlet->name) }}" class="mt-1 w-full rounded border px-2 py-2">
            </label>
            <label class="text-sm">Timezone
                <input name="timezone" value="{{ old('timezone', $outlet->timezone) }}" class="mt-1 w-full rounded border px-2 py-2">
            </label>
            <label class="text-sm md:col-span-2">Alamat
                <textarea name="address" class="mt-1 w-full rounded border px-2 py-2">{{ old('address', $outlet->address) }}</textarea>
            </label>
            <label class="text-sm">Tax %
                <input type="number" name="tax_percent" value="{{ old('tax_percent', $outlet->tax_percent) }}" class="mt-1 w-full rounded border px-2 py-2">
            </label>
            <label class="text-sm">Service %
                <input type="number" name="service_percent" value="{{ old('service_percent', $outlet->service_percent) }}" class="mt-1 w-full rounded border px-2 py-2">
            </label>
            <label class="text-sm md:col-span-2">Receipt Header
                <textarea name="receipt_header" class="mt-1 w-full rounded border px-2 py-2">{{ old('receipt_header', $outlet->receipt_header) }}</textarea>
            </label>
            <label class="text-sm md:col-span-2">Receipt Footer
                <textarea name="receipt_footer" class="mt-1 w-full rounded border px-2 py-2">{{ old('receipt_footer', $outlet->receipt_footer) }}</textarea>
            </label>
            <button class="rounded bg-slate-900 px-3 py-2 text-white md:col-span-2 md:w-max">Simpan</button>
        </form>
    </div>
</x-layouts.app>
