<x-layouts.app title="Reports">
    <div class="grid gap-3 md:grid-cols-3">
        <div class="rounded-xl border border-slate-200 bg-white p-4">
            <p class="text-sm text-slate-500">Sales Today</p>
            <p class="text-xl font-semibold">Rp {{ number_format($salesToday, 0, ',', '.') }}</p>
        </div>
        <div class="rounded-xl border border-slate-200 bg-white p-4">
            <p class="text-sm text-slate-500">Transactions Today</p>
            <p class="text-xl font-semibold">{{ $transactionsToday }}</p>
        </div>
        <div class="rounded-xl border border-slate-200 bg-white p-4">
            <p class="text-sm text-slate-500">Top Product</p>
            <p class="text-xl font-semibold">{{ $topProducts->first()->name_snapshot ?? '-' }}</p>
        </div>
    </div>

    <div class="mt-4 rounded-xl border border-slate-200 bg-white p-4">
        <h2 class="mb-3 text-lg font-semibold">Laporan Harian</h2>
        <form class="mb-4 flex flex-wrap gap-2 text-sm">
            <input name="from" type="date" value="{{ $from }}" class="rounded border px-2 py-2">
            <input name="to" type="date" value="{{ $to }}" class="rounded border px-2 py-2">
            <button class="rounded bg-slate-900 px-3 py-2 text-white">Filter</button>
        </form>
        <div class="grid gap-2 md:grid-cols-5 text-sm">
            <div>Total Sales: Rp {{ number_format($summary['total_sales'], 0, ',', '.') }}</div>
            <div>Tax: Rp {{ number_format($summary['total_tax'], 0, ',', '.') }}</div>
            <div>Service: Rp {{ number_format($summary['total_service'], 0, ',', '.') }}</div>
            <div>Net: Rp {{ number_format($summary['net_sales'], 0, ',', '.') }}</div>
            <div>Orders: {{ $summary['count_orders'] }}</div>
        </div>
    </div>
</x-layouts.app>
