<x-layouts.app :title="'Order '.$order->receipt_number">
    <div class="grid gap-4 lg:grid-cols-2">
        <section class="rounded-xl border border-slate-200 bg-white p-4">
            <h1 class="mb-2 text-lg font-semibold">Order {{ $order->receipt_number }}</h1>
            <p class="text-sm text-slate-500">Status: {{ $order->status }}</p>
            <p class="text-sm text-slate-500">Kitchen: {{ $order->kitchen_status }}</p>
            <div class="mt-3 space-y-2 text-sm">
                @foreach($order->items as $item)
                    <div class="flex items-center justify-between border-b pb-1">
                        <span>{{ $item->name_snapshot }} x{{ $item->qty }}</span>
                        <span>Rp {{ number_format($item->line_total, 0, ',', '.') }}</span>
                    </div>
                @endforeach
            </div>
            <div class="mt-4 space-y-1 text-sm">
                <div class="flex justify-between"><span>Subtotal</span><span>Rp {{ number_format($order->subtotal, 0, ',', '.') }}</span></div>
                <div class="flex justify-between"><span>Tax</span><span>Rp {{ number_format($order->tax, 0, ',', '.') }}</span></div>
                <div class="flex justify-between"><span>Service</span><span>Rp {{ number_format($order->service, 0, ',', '.') }}</span></div>
                <div class="flex justify-between"><span>Refund</span><span>Rp {{ number_format($order->refund_total, 0, ',', '.') }}</span></div>
                <div class="flex justify-between font-semibold"><span>Total</span><span>Rp {{ number_format($order->total, 0, ',', '.') }}</span></div>
            </div>

            <div class="mt-4 flex gap-2">
                <a href="{{ route('orders.print', $order) }}" target="_blank" class="rounded bg-slate-900 px-3 py-2 text-sm text-white">Print Thermal Receipt</a>
                @if(in_array(auth()->user()->role, ['owner','admin'], true) && $order->status === 'PAID')
                    <form method="POST" action="{{ route('orders.void', $order) }}" class="flex gap-2">
                        @csrf
                        <input name="reason" required placeholder="Alasan void" class="rounded border px-2 py-1 text-sm">
                        <button class="rounded bg-rose-600 px-3 py-2 text-sm text-white">Void</button>
                    </form>
                @endif
            </div>

            @if(in_array(auth()->user()->role, ['owner','admin'], true) && in_array($order->status, ['PAID','REFUNDED'], true))
                <form method="POST" action="{{ route('orders.refund', $order) }}" class="mt-3 grid grid-cols-4 gap-2 text-sm">
                    @csrf
                    <input name="amount" type="number" required placeholder="Nominal refund" class="rounded border px-2 py-1">
                    <select name="method" class="rounded border px-2 py-1">
                        <option value="CASH">CASH</option>
                        <option value="QRIS">QRIS</option>
                        <option value="DEBIT">DEBIT</option>
                    </select>
                    <input name="reason" required placeholder="Alasan refund" class="rounded border px-2 py-1">
                    <button class="rounded bg-amber-600 px-3 py-2 text-white">Refund</button>
                </form>
            @endif
        </section>

        <section class="rounded-xl border border-slate-200 bg-white p-4 print:block">
            <h2 class="mb-2 text-lg font-semibold">Template Receipt</h2>
            <p class="text-sm">{{ $order->outlet->receipt_header }}</p>
            <hr class="my-2">
            @foreach($order->items as $item)
                <div class="flex justify-between text-sm">
                    <span>{{ $item->name_snapshot }} x{{ $item->qty }}</span>
                    <span>{{ number_format($item->line_total, 0, ',', '.') }}</span>
                </div>
            @endforeach
            <hr class="my-2">
            <div class="flex justify-between text-sm font-semibold">
                <span>Total</span>
                <span>{{ number_format($order->total, 0, ',', '.') }}</span>
            </div>
            <p class="mt-3 text-xs">{{ $order->outlet->receipt_footer }}</p>
        </section>
    </div>
</x-layouts.app>
