<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Receipt {{ $order->receipt_number }}</title>
    <style>
        @page { size: 80mm auto; margin: 3mm; }
        body { font-family: "Courier New", monospace; width: 72mm; margin: 0 auto; color: #111; font-size: 12px; }
        .center { text-align: center; }
        .row { display: flex; justify-content: space-between; gap: 8px; }
        .line { border-top: 1px dashed #111; margin: 6px 0; }
        .muted { color: #555; }
        .total { font-weight: 700; font-size: 13px; }
    </style>
</head>
<body onload="window.print()">
    <div class="center">
        <div><strong>{{ $order->outlet->name }}</strong></div>
        @if($order->outlet->address)<div class="muted">{{ $order->outlet->address }}</div>@endif
        @if($order->outlet->receipt_header)<div>{{ $order->outlet->receipt_header }}</div>@endif
    </div>

    <div class="line"></div>
    <div class="row"><span>No</span><span>{{ $order->receipt_number }}</span></div>
    <div class="row"><span>Kasir</span><span>#{{ $order->user_id }}</span></div>
    <div class="row"><span>Tanggal</span><span>{{ $order->created_at->format('d/m/Y H:i') }}</span></div>
    <div class="line"></div>

    @foreach($order->items as $item)
        <div>{{ $item->name_snapshot }}</div>
        <div class="row muted">
            <span>{{ $item->qty }} x {{ number_format($item->base_price, 0, ',', '.') }}</span>
            <span>{{ number_format($item->line_total, 0, ',', '.') }}</span>
        </div>
    @endforeach

    <div class="line"></div>
    <div class="row"><span>Subtotal</span><span>{{ number_format($order->subtotal, 0, ',', '.') }}</span></div>
    <div class="row"><span>Diskon</span><span>{{ number_format($order->discount, 0, ',', '.') }}</span></div>
    <div class="row"><span>Pajak</span><span>{{ number_format($order->tax, 0, ',', '.') }}</span></div>
    <div class="row"><span>Service</span><span>{{ number_format($order->service, 0, ',', '.') }}</span></div>
    <div class="row total"><span>Total</span><span>{{ number_format($order->total, 0, ',', '.') }}</span></div>

    <div class="line"></div>
    @foreach($order->payments as $payment)
        <div class="row"><span>{{ $payment->method }}</span><span>{{ number_format($payment->amount, 0, ',', '.') }}</span></div>
    @endforeach
    <div class="line"></div>

    <div class="center muted">
        @if($order->outlet->receipt_footer)
            {{ $order->outlet->receipt_footer }}
        @else
            Terima kasih.
        @endif
    </div>
</body>
</html>
