<x-layouts.app title="Orders">
    <div class="rounded-xl border border-slate-200 bg-white p-4">
        <h1 class="mb-4 text-lg font-semibold">Riwayat Order</h1>
        <div class="overflow-auto">
            <table class="min-w-full text-sm">
                <thead class="bg-slate-50 text-left">
                <tr>
                    <th class="px-2 py-2">Receipt</th>
                    <th class="px-2 py-2">Status</th>
                    <th class="px-2 py-2">Kitchen</th>
                    <th class="px-2 py-2">Total</th>
                    <th class="px-2 py-2">Kasir</th>
                    <th class="px-2 py-2">Waktu</th>
                    <th class="px-2 py-2"></th>
                </tr>
                </thead>
                <tbody>
                @foreach($orders as $order)
                    <tr class="border-t">
                        <td class="px-2 py-2">{{ $order->receipt_number ?? '-' }}</td>
                        <td class="px-2 py-2">{{ $order->status }}</td>
                        <td class="px-2 py-2">{{ $order->kitchen_status }}</td>
                        <td class="px-2 py-2">Rp {{ number_format($order->total, 0, ',', '.') }}</td>
                        <td class="px-2 py-2">#{{ $order->user_id }}</td>
                        <td class="px-2 py-2">{{ $order->created_at }}</td>
                        <td class="px-2 py-2">
                            <a class="text-sky-700" href="{{ route('orders.show', $order) }}">Detail</a>
                        </td>
                    </tr>
                @endforeach
                </tbody>
            </table>
        </div>
        <div class="mt-4">{{ $orders->links() }}</div>
    </div>
</x-layouts.app>
