<x-layouts.app title="Offline Queue">
    <div x-data="queuePage()" x-init="init()" class="rounded-xl border border-slate-200 bg-white p-4">
        <div class="mb-3 flex items-center justify-between">
            <h1 class="text-lg font-semibold">Offline Queue</h1>
            <button @click="retrySync" class="rounded bg-slate-900 px-3 py-2 text-sm text-white">Retry Sync</button>
        </div>
        <p class="mb-3 text-sm text-slate-500">Daftar order pending dan error sinkronisasi dari perangkat ini.</p>
        <template x-if="items.length === 0">
            <p class="text-sm">Tidak ada queue pending.</p>
        </template>
        <template x-for="it in items" :key="it.id">
            <div class="mb-2 rounded border p-2 text-sm">
                <div class="flex justify-between">
                    <span x-text="it.payload.client_order_id"></span>
                    <span x-text="'items: ' + it.payload.items.length"></span>
                </div>
            </div>
        </template>
    </div>

    <script>
        function queuePage() {
            return {
                items: [],
                async init() { this.items = await window.offlineQueue.all(); },
                async retrySync() {
                    window.dispatchEvent(new Event('online'));
                    this.items = await window.offlineQueue.all();
                },
            };
        }
    </script>
</x-layouts.app>
