<x-layouts.app title="Manajemen Meja">
    <div x-data="tableManager()" class="space-y-6">

        {{-- Header + Add form --}}
        <div class="surface p-4">
            <h2 class="mb-4 text-base font-bold">Tambah Meja Baru</h2>
            <form method="POST" action="{{ route('master.tables.store') }}" class="flex gap-3">
                @csrf
                <input
                    type="text"
                    name="name"
                    placeholder="Nama meja (misal: Meja 1, VIP A)"
                    required
                    class="flex-1 rounded-xl border border-slate-200 bg-slate-50 px-3 py-2 text-sm outline-none focus:border-sky-300 focus:bg-white">
                <button type="submit" class="rounded-xl bg-slate-900 px-4 py-2 text-sm font-semibold text-white">
                    + Tambah
                </button>
            </form>
        </div>

        {{-- Table list --}}
        <div class="surface overflow-hidden p-0">
            <div class="border-b border-slate-200 px-4 py-3">
                <h2 class="text-sm font-bold">Daftar Meja ({{ $tables->count() }})</h2>
            </div>

            @if($tables->isEmpty())
                <div class="px-4 py-12 text-center text-sm text-slate-400">
                    Belum ada meja. Tambah meja di atas.
                </div>
            @else
                <div class="divide-y divide-slate-100">
                    @foreach($tables as $table)
                        <div class="flex items-center gap-4 px-4 py-4" x-data="{ editOpen: false, qrOpen: false }">

                            {{-- QR + Info --}}
                            <div class="min-w-0 flex-1">
                                <div class="flex items-center gap-2">
                                    <p class="text-sm font-semibold text-slate-800">{{ $table->name }}</p>
                                    @if($table->is_active)
                                        <span class="rounded-full bg-emerald-100 px-2 py-0.5 text-[10px] font-semibold text-emerald-700">Aktif</span>
                                    @else
                                        <span class="rounded-full bg-slate-100 px-2 py-0.5 text-[10px] font-semibold text-slate-500">Nonaktif</span>
                                    @endif
                                </div>
                                <p class="mt-0.5 truncate text-xs text-slate-400">
                                    {{ $table->menu_url }}
                                </p>
                            </div>

                            {{-- Actions --}}
                            <div class="flex shrink-0 items-center gap-2">
                                {{-- View QR --}}
                                <button
                                    @click="qrOpen = true"
                                    class="rounded-lg border border-slate-200 px-3 py-1.5 text-xs font-medium text-slate-600 hover:bg-slate-50">
                                    QR Code
                                </button>

                                {{-- Open menu --}}
                                <a
                                    href="{{ $table->menu_url }}"
                                    target="_blank"
                                    class="rounded-lg border border-sky-200 px-3 py-1.5 text-xs font-medium text-sky-600 hover:bg-sky-50">
                                    Lihat Menu
                                </a>

                                {{-- Edit --}}
                                <button
                                    @click="editOpen = true"
                                    class="rounded-lg border border-amber-200 px-3 py-1.5 text-xs font-medium text-amber-600 hover:bg-amber-50">
                                    Edit
                                </button>

                                {{-- Delete --}}
                                <form method="POST" action="{{ route('master.tables.destroy', $table) }}"
                                      onsubmit="return confirm('Hapus meja {{ $table->name }}?')">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit"
                                            class="rounded-lg border border-rose-200 px-3 py-1.5 text-xs font-medium text-rose-600 hover:bg-rose-50">
                                        Hapus
                                    </button>
                                </form>
                            </div>

                            {{-- QR Modal --}}
                            <div x-show="qrOpen" x-transition class="fixed inset-0 z-50 flex items-center justify-center bg-slate-900/40 p-4">
                                <div class="surface w-full max-w-sm p-6 text-center">
                                    <h3 class="mb-1 text-base font-bold">{{ $table->name }}</h3>
                                    <p class="mb-4 text-xs text-slate-500">Scan QR untuk memesan</p>
                                    <div id="qr-{{ $table->id }}" class="mx-auto mb-4 flex h-48 w-48 items-center justify-center"></div>
                                    <p class="mb-4 break-all text-[10px] text-slate-400">{{ $table->menu_url }}</p>
                                    <div class="flex gap-2">
                                        <button
                                            onclick="window.print()"
                                            class="flex-1 rounded-xl border border-slate-200 py-2 text-sm text-slate-600">
                                            Print
                                        </button>
                                        <button
                                            @click="qrOpen = false"
                                            class="flex-1 rounded-xl bg-slate-900 py-2 text-sm text-white">
                                            Tutup
                                        </button>
                                    </div>
                                </div>
                                <script>
                                    (function() {
                                        const el = document.getElementById('qr-{{ $table->id }}');
                                        if (el && typeof QRCode !== 'undefined') {
                                            new QRCode(el, {
                                                text: '{{ $table->menu_url }}',
                                                width: 192,
                                                height: 192,
                                                colorDark: '#0f172a',
                                                colorLight: '#ffffff',
                                            });
                                        }
                                    })();
                                </script>
                            </div>

                            {{-- Edit Modal --}}
                            <div x-show="editOpen" x-transition class="fixed inset-0 z-50 flex items-center justify-center bg-slate-900/40 p-4">
                                <div class="surface w-full max-w-sm p-4">
                                    <h3 class="mb-3 text-sm font-bold">Edit Meja</h3>
                                    <form method="POST" action="{{ route('master.tables.update', $table) }}" class="space-y-3">
                                        @csrf
                                        @method('PUT')
                                        <input
                                            type="text"
                                            name="name"
                                            value="{{ $table->name }}"
                                            required
                                            class="w-full rounded-xl border border-slate-200 bg-slate-50 px-3 py-2 text-sm outline-none focus:border-sky-300 focus:bg-white">
                                        <label class="flex items-center gap-2 text-sm">
                                            <input type="checkbox" name="is_active" value="1" {{ $table->is_active ? 'checked' : '' }}>
                                            <span>Aktif</span>
                                        </label>
                                        <div class="flex gap-2">
                                            <button type="button" @click="editOpen = false"
                                                    class="flex-1 rounded-xl border border-slate-200 py-2 text-sm">Batal</button>
                                            <button type="submit"
                                                    class="flex-1 rounded-xl bg-slate-900 py-2 text-sm text-white">Simpan</button>
                                        </div>
                                    </form>
                                </div>
                            </div>

                        </div>
                    @endforeach
                </div>
            @endif
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/qrcodejs@1.0.0/qrcode.min.js"></script>
    <script>
        function tableManager() {
            return {};
        }
    </script>
</x-layouts.app>
