<x-layouts.app title="Produk">
    <div class="grid gap-4 lg:grid-cols-[380px_1fr]">
        <section class="rounded-xl border border-slate-200 bg-white p-4">
            <h1 class="mb-3 text-lg font-semibold">Tambah Produk/Menu</h1>
            <form method="POST" action="{{ route('master.products.store') }}" enctype="multipart/form-data" class="space-y-2 text-sm">
                @csrf
                <input name="name" required placeholder="Nama produk" class="w-full rounded border px-3 py-2">
                <input name="sku" required placeholder="SKU unik" class="w-full rounded border px-3 py-2">
                <select name="category_id" class="w-full rounded border px-3 py-2">
                    <option value="">- Kategori -</option>
                    @foreach($categories as $cat)
                        <option value="{{ $cat->id }}">{{ $cat->name }}</option>
                    @endforeach
                </select>
                <input name="base_price" type="number" required placeholder="Harga jual (rupiah)" class="w-full rounded border px-3 py-2">
                <input name="cost" type="number" placeholder="HPP (opsional)" class="w-full rounded border px-3 py-2">
                <input name="image_file" type="file" accept="image/*" class="w-full rounded border px-3 py-2">
                <input name="image_url" placeholder="Image URL (opsional)" class="w-full rounded border px-3 py-2">
                <label class="inline-flex items-center gap-2">
                    <input type="checkbox" name="is_active" value="1" checked>
                    <span>Aktif</span>
                </label>
                <button class="w-full rounded bg-slate-900 px-3 py-2 text-white">Simpan</button>
            </form>
        </section>

        <section class="rounded-xl border border-slate-200 bg-white p-4">
            <h2 class="mb-3 text-lg font-semibold">Daftar Produk</h2>
            <div class="overflow-auto">
                <table class="min-w-full text-sm">
                    <thead class="bg-slate-50 text-left">
                    <tr>
                        <th class="px-2 py-2">Foto</th>
                        <th class="px-2 py-2">Nama</th>
                        <th class="px-2 py-2">SKU</th>
                        <th class="px-2 py-2">Kategori</th>
                        <th class="px-2 py-2">Harga</th>
                        <th class="px-2 py-2">Status</th>
                        <th class="px-2 py-2"></th>
                    </tr>
                    </thead>
                    <tbody>
                    @foreach($products as $product)
                        <tr class="border-t">
                            <td class="px-2 py-2">
                                <img src="{{ $product->image_url ?: '/icons/icon-192.svg' }}" alt="" class="h-10 w-10 rounded-lg object-cover">
                            </td>
                            <td class="px-2 py-2">{{ $product->name }}</td>
                            <td class="px-2 py-2">{{ $product->sku }}</td>
                            <td class="px-2 py-2">{{ $product->category?->name ?? '-' }}</td>
                            <td class="px-2 py-2">Rp {{ number_format($product->base_price, 0, ',', '.') }}</td>
                            <td class="px-2 py-2">{{ $product->is_active ? 'Aktif' : 'Nonaktif' }}</td>
                            <td class="px-2 py-2">
                                <a class="rounded bg-slate-900 px-2 py-1 text-xs text-white" href="{{ route('master.products.edit', $product) }}">Edit</a>
                            </td>
                        </tr>
                    @endforeach
                    </tbody>
                </table>
            </div>
            <div class="mt-4">{{ $products->links() }}</div>
        </section>
    </div>
</x-layouts.app>
