<x-layouts.app :title="'Edit '.$product->name">
    <div class="space-y-4">
        <section class="rounded-xl border border-slate-200 bg-white p-4">
            <h1 class="mb-3 text-lg font-semibold">Edit Produk: {{ $product->name }}</h1>
            <form method="POST" action="{{ route('master.products.update', $product) }}" enctype="multipart/form-data" class="grid gap-2 md:grid-cols-2">
                @csrf
                @method('PUT')
                <input name="name" value="{{ $product->name }}" required class="rounded border px-3 py-2">
                <input name="sku" value="{{ $product->sku }}" required class="rounded border px-3 py-2">
                <select name="category_id" class="rounded border px-3 py-2">
                    <option value="">- Kategori -</option>
                    @foreach($categories as $cat)
                        <option value="{{ $cat->id }}" @selected($product->category_id === $cat->id)>{{ $cat->name }}</option>
                    @endforeach
                </select>
                <input name="base_price" type="number" value="{{ $product->base_price }}" required class="rounded border px-3 py-2">
                <input name="cost" type="number" value="{{ $product->cost }}" class="rounded border px-3 py-2">
                <input name="image_file" type="file" accept="image/*" class="rounded border px-3 py-2">
                <input name="image_url" value="{{ $product->image_url }}" class="rounded border px-3 py-2">
                <div class="md:col-span-2">
                    <img src="{{ $product->image_url ?: '/icons/icon-192.svg' }}" alt="" class="h-24 w-24 rounded-xl object-cover">
                </div>
                <label class="inline-flex items-center gap-2 md:col-span-2">
                    <input type="checkbox" name="is_active" value="1" @checked($product->is_active)>
                    <span>Aktif</span>
                </label>
                <div class="md:col-span-2">
                    <button class="rounded bg-slate-900 px-3 py-2 text-sm text-white">Update Produk</button>
                </div>
            </form>
            <form method="POST" action="{{ route('master.products.destroy', $product) }}" class="mt-2">
                @csrf
                @method('DELETE')
                <button onclick="return confirm('Hapus produk?')" class="rounded bg-rose-600 px-3 py-2 text-sm text-white">Hapus Produk</button>
            </form>
        </section>

        <div class="grid gap-4 lg:grid-cols-2">
            <section class="rounded-xl border border-slate-200 bg-white p-4">
                <h2 class="mb-3 text-lg font-semibold">Variant Group & Options</h2>
                <form method="POST" action="{{ route('master.variants.store', $product) }}" class="mb-4 grid grid-cols-4 gap-2 text-sm">
                    @csrf
                    <input name="name" required placeholder="Nama group (Size)" class="col-span-2 rounded border px-2 py-2">
                    <input name="max_selection" type="number" value="1" class="rounded border px-2 py-2">
                    <label class="inline-flex items-center gap-2 rounded border px-2">
                        <input type="checkbox" name="is_required" value="1">
                        Required
                    </label>
                    <button class="col-span-4 rounded bg-slate-900 px-3 py-2 text-white">Tambah Group</button>
                </form>

                <div class="space-y-3">
                    @foreach($product->variants as $variant)
                        <div class="rounded border p-3">
                            <form method="POST" action="{{ route('master.variants.update', $variant) }}" class="grid grid-cols-4 gap-2 text-sm">
                                @csrf
                                @method('PUT')
                                <input name="name" value="{{ $variant->name }}" class="col-span-2 rounded border px-2 py-1">
                                <input name="max_selection" type="number" value="{{ $variant->max_selection }}" class="rounded border px-2 py-1">
                                <label class="inline-flex items-center gap-2 rounded border px-2">
                                    <input type="checkbox" name="is_required" value="1" @checked($variant->is_required)>
                                    Required
                                </label>
                                <button class="rounded bg-slate-900 px-2 py-1 text-xs text-white">Update Group</button>
                            </form>
                            <form method="POST" action="{{ route('master.variants.destroy', $variant) }}" class="mt-2">
                                @csrf
                                @method('DELETE')
                                <button onclick="return confirm('Hapus group variant?')" class="rounded bg-rose-600 px-2 py-1 text-xs text-white">Hapus Group</button>
                            </form>

                            <div class="mt-2 space-y-1">
                                @foreach($variant->options as $option)
                                    <div class="grid grid-cols-2 gap-2 text-sm">
                                        <form method="POST" action="{{ route('master.variant-options.update', $option) }}" class="grid grid-cols-2 gap-2">
                                            @csrf
                                            @method('PUT')
                                            <input name="name" value="{{ $option->name }}" class="rounded border px-2 py-1">
                                            <input name="price_delta" type="number" value="{{ $option->price_delta }}" class="rounded border px-2 py-1">
                                            <button class="col-span-2 rounded bg-slate-800 px-2 py-1 text-xs text-white">Update Option</button>
                                        </form>
                                        <form method="POST" action="{{ route('master.variant-options.destroy', $option) }}">
                                            @csrf
                                            @method('DELETE')
                                            <button onclick="return confirm('Hapus option?')" class="rounded bg-rose-600 px-2 py-1 text-xs text-white">Hapus Option</button>
                                        </form>
                                    </div>
                                @endforeach
                            </div>

                            <form method="POST" action="{{ route('master.variant-options.store', $variant) }}" class="mt-2 grid grid-cols-3 gap-2 text-sm">
                                @csrf
                                <input name="name" required placeholder="Nama option" class="rounded border px-2 py-1">
                                <input name="price_delta" type="number" value="0" class="rounded border px-2 py-1">
                                <button class="rounded bg-emerald-600 px-2 py-1 text-xs text-white">Tambah Option</button>
                            </form>
                        </div>
                    @endforeach
                </div>
            </section>

            <section class="rounded-xl border border-slate-200 bg-white p-4">
                <h2 class="mb-3 text-lg font-semibold">Add-ons</h2>
                <form method="POST" action="{{ route('master.addons.store', $product) }}" class="mb-4 grid grid-cols-3 gap-2 text-sm">
                    @csrf
                    <input name="name" required placeholder="Nama add-on" class="rounded border px-2 py-2">
                    <input name="price" type="number" required placeholder="Harga" class="rounded border px-2 py-2">
                    <button class="rounded bg-slate-900 px-2 py-2 text-white">Tambah Add-on</button>
                </form>

                <div class="space-y-2">
                    @foreach($product->addons as $addon)
                        <div class="rounded border p-2">
                            <form method="POST" action="{{ route('master.addons.update', $addon) }}" class="grid grid-cols-3 gap-2 text-sm">
                                @csrf
                                @method('PUT')
                                <input name="name" value="{{ $addon->name }}" class="rounded border px-2 py-1">
                                <input name="price" type="number" value="{{ $addon->price }}" class="rounded border px-2 py-1">
                                <button class="rounded bg-slate-800 px-2 py-1 text-xs text-white">Update</button>
                            </form>
                            <form method="POST" action="{{ route('master.addons.destroy', $addon) }}" class="mt-1">
                                @csrf
                                @method('DELETE')
                                <button onclick="return confirm('Hapus add-on?')" class="rounded bg-rose-600 px-2 py-1 text-xs text-white">Hapus</button>
                            </form>
                        </div>
                    @endforeach
                </div>
            </section>
        </div>
    </div>
</x-layouts.app>
