<x-layouts.app title="Kategori">
    <div class="grid gap-4 lg:grid-cols-2">
        <section class="rounded-xl border border-slate-200 bg-white p-4">
            <h1 class="mb-3 text-lg font-semibold">Tambah Kategori</h1>
            <form method="POST" action="{{ route('master.categories.store') }}" class="space-y-3">
                @csrf
                <input name="name" required placeholder="Nama kategori" class="w-full rounded border px-3 py-2">
                <input name="sort_order" type="number" value="0" class="w-full rounded border px-3 py-2">
                <button class="rounded bg-slate-900 px-3 py-2 text-sm text-white">Simpan</button>
            </form>
        </section>

        <section class="rounded-xl border border-slate-200 bg-white p-4">
            <h2 class="mb-3 text-lg font-semibold">Daftar Kategori</h2>
            <div class="space-y-2">
                @foreach($categories as $category)
                    <div class="rounded border p-2">
                        <form method="POST" action="{{ route('master.categories.update', $category) }}" class="grid grid-cols-[1fr_100px_auto] gap-2">
                            @csrf
                            @method('PUT')
                            <input name="name" value="{{ $category->name }}" class="rounded border px-2 py-1">
                            <input name="sort_order" type="number" value="{{ $category->sort_order }}" class="rounded border px-2 py-1">
                            <button class="rounded bg-slate-900 px-2 py-1 text-xs text-white">Update</button>
                        </form>
                        <form method="POST" action="{{ route('master.categories.destroy', $category) }}" class="mt-2">
                            @csrf
                            @method('DELETE')
                            <button onclick="return confirm('Hapus kategori?')"
                                    class="rounded bg-rose-600 px-2 py-1 text-xs text-white">Hapus</button>
                        </form>
                    </div>
                @endforeach
            </div>
            <div class="mt-4">{{ $categories->links() }}</div>
        </section>
    </div>
</x-layouts.app>
