<x-layouts.app title="Kitchen Display">
    <div class="grid gap-4 md:grid-cols-2 xl:grid-cols-3">
        @forelse($orders as $order)
            <div class="surface p-4">
                <div class="mb-2 flex items-center justify-between">
                    <div>
                        <p class="text-sm font-semibold">{{ $order->receipt_number }}</p>
                        <p class="text-xs text-slate-500">{{ $order->created_at->format('d M H:i') }}</p>
                    </div>
                    <span class="rounded-full px-2 py-1 text-xs font-semibold
                        {{ $order->kitchen_status === 'NEW' ? 'bg-sky-100 text-sky-700' : '' }}
                        {{ $order->kitchen_status === 'PREPARING' ? 'bg-amber-100 text-amber-700' : '' }}
                        {{ $order->kitchen_status === 'READY' ? 'bg-emerald-100 text-emerald-700' : '' }}">
                        {{ $order->kitchen_status }}
                    </span>
                </div>
                <div class="mb-3 space-y-1 text-sm">
                    @foreach($order->items as $item)
                        <div class="flex justify-between">
                            <span>{{ $item->name_snapshot }}</span>
                            <strong>x{{ $item->qty }}</strong>
                        </div>
                    @endforeach
                </div>
                <div class="flex flex-wrap gap-2">
                    @foreach(['NEW','PREPARING','READY','SERVED'] as $status)
                        <form method="POST" action="{{ route('kds.update', $order) }}">
                            @csrf
                            <input type="hidden" name="kitchen_status" value="{{ $status }}">
                            <button class="rounded-lg border px-2 py-1 text-xs {{ $order->kitchen_status === $status ? 'border-slate-900 bg-slate-900 text-white' : 'border-slate-200 bg-white' }}">
                                {{ $status }}
                            </button>
                        </form>
                    @endforeach
                </div>
            </div>
        @empty
            <div class="surface p-4 text-sm text-slate-500">Belum ada order untuk dapur.</div>
        @endforelse
    </div>
</x-layouts.app>
