<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Status Pesanan — {{ $table->outlet->name ?? '' }}</title>
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
</head>
<body class="bg-slate-50 text-slate-900 antialiased">

<header class="sticky top-0 z-20 border-b border-slate-200 bg-white shadow-sm">
    <div class="mx-auto flex max-w-lg items-center justify-between px-4 py-3">
        <div>
            <p class="text-sm font-bold text-slate-900">{{ $table->outlet->name ?? 'Pesanan' }}</p>
            <p class="text-xs text-slate-500">{{ $table->name }}</p>
        </div>
        <a href="{{ route('customer.menu', $table->qr_token) }}"
           class="rounded-xl border border-slate-200 bg-white px-3 py-1.5 text-xs font-semibold text-slate-700">
            Pesan Lagi
        </a>
    </div>
</header>

<main
    x-data="statusApp({ orderId: {{ $order->id }}, refreshUrl: '{{ route('customer.order.status', ['token' => $table->qr_token, 'order' => $order->id]) }}' })"
    x-init="startPolling()"
    class="mx-auto max-w-lg px-4 py-6">

    {{-- Status badge --}}
    <div class="mb-6 text-center">
        @php
            $statusConfig = [
                'NEW'       => ['label' => 'Pesanan Diterima',    'color' => 'bg-slate-100 text-slate-700',    'icon' => '📋'],
                'PREPARING' => ['label' => 'Sedang Dimasak',      'color' => 'bg-amber-100 text-amber-700',    'icon' => '👨‍🍳'],
                'READY'     => ['label' => 'Pesanan Siap!',        'color' => 'bg-emerald-100 text-emerald-700','icon' => '✅'],
                'SERVED'    => ['label' => 'Sudah Disajikan',      'color' => 'bg-sky-100 text-sky-700',        'icon' => '🍽️'],
            ];
            $cfg = $statusConfig[$order->kitchen_status] ?? $statusConfig['NEW'];
        @endphp

        <div id="status-badge" class="inline-flex flex-col items-center gap-2 rounded-2xl {{ $cfg['color'] }} px-8 py-4">
            <span class="text-4xl">{{ $cfg['icon'] }}</span>
            <span class="text-base font-bold">{{ $cfg['label'] }}</span>
        </div>

        <p class="mt-3 text-xs text-slate-400">Auto-refresh setiap 15 detik</p>
        <div class="mx-auto mt-1 h-1 w-24 overflow-hidden rounded-full bg-slate-200">
            <div class="h-full animate-pulse rounded-full bg-slate-400" style="animation: progress 15s linear infinite;"></div>
        </div>
    </div>

    {{-- Receipt number --}}
    <div class="mb-4 rounded-2xl border border-slate-200 bg-white p-4 text-center">
        <p class="text-xs text-slate-500">Nomor Pesanan</p>
        <p class="mt-1 text-xl font-bold text-slate-900">{{ $order->receipt_number }}</p>
        <p class="mt-1 text-xs text-slate-400">{{ $order->created_at->format('d M Y, H:i') }}</p>
    </div>

    {{-- Items --}}
    <div class="rounded-2xl border border-slate-200 bg-white p-4">
        <p class="mb-3 text-xs font-semibold uppercase tracking-wide text-slate-500">Pesanan Anda</p>
        <div class="space-y-2">
            @foreach($order->items as $item)
                <div class="flex items-start justify-between gap-2">
                    <div class="min-w-0 flex-1">
                        <p class="text-sm font-semibold text-slate-800">
                            {{ $item->qty }}x {{ $item->name_snapshot }}
                        </p>
                        @if($item->variant_snapshot)
                            <p class="text-xs text-slate-400">{{ $item->variant_snapshot['group'] }}: {{ $item->variant_snapshot['option'] }}</p>
                        @endif
                        @if($item->addons_snapshot && count($item->addons_snapshot))
                            <p class="text-xs text-slate-400">+ {{ collect($item->addons_snapshot)->pluck('name')->join(', ') }}</p>
                        @endif
                        @if($item->note)
                            <p class="text-xs text-emerald-600">{{ $item->note }}</p>
                        @endif
                    </div>
                    <p class="shrink-0 text-sm font-semibold">Rp {{ number_format($item->line_total, 0, ',', '.') }}</p>
                </div>
            @endforeach
        </div>

        <div class="mt-3 space-y-1 border-t pt-3 text-sm">
            <div class="flex justify-between text-slate-500">
                <span>Subtotal</span>
                <span>Rp {{ number_format($order->subtotal, 0, ',', '.') }}</span>
            </div>
            @if($order->tax)
                <div class="flex justify-between text-slate-500">
                    <span>Pajak</span>
                    <span>Rp {{ number_format($order->tax, 0, ',', '.') }}</span>
                </div>
            @endif
            @if($order->service)
                <div class="flex justify-between text-slate-500">
                    <span>Service</span>
                    <span>Rp {{ number_format($order->service, 0, ',', '.') }}</span>
                </div>
            @endif
            <div class="flex justify-between border-t pt-2 text-base font-bold">
                <span>Total</span>
                <span>Rp {{ number_format($order->total, 0, ',', '.') }}</span>
            </div>
        </div>
    </div>

    {{-- Payment info --}}
    <div class="mt-3 rounded-2xl border border-emerald-200 bg-emerald-50 p-3 text-center text-sm text-emerald-700">
        ✓ Pembayaran via QRIS — Rp {{ number_format($order->total, 0, ',', '.') }}
    </div>

    <a href="{{ route('customer.menu', $table->qr_token) }}"
       class="mt-6 flex w-full items-center justify-center rounded-2xl border border-slate-200 bg-white py-3 text-sm font-semibold text-slate-700">
        + Pesan Lagi
    </a>

</main>

<style>
@keyframes progress {
    from { width: 0; }
    to { width: 100%; }
}
</style>

<script>
function statusApp({ orderId, refreshUrl }) {
    return {
        startPolling() {
            setInterval(() => {
                window.location.reload();
            }, 15000);
        },
    };
}
</script>
</body>
</html>
