<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>{{ $title ?? ($outlet->name ?? 'Menu') }}</title>
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
</head>
<body class="bg-slate-50 text-slate-900 antialiased">
    <header class="sticky top-0 z-20 border-b border-slate-200 bg-white shadow-sm">
        <div class="mx-auto flex max-w-lg items-center justify-between px-4 py-3">
            <div>
                <p class="text-sm font-bold text-slate-900">{{ $outlet->name ?? 'Menu' }}</p>
                @isset($table)
                    <p class="text-xs text-slate-500">{{ $table->name }}</p>
                @endisset
            </div>
            @isset($cartBadge)
                {{ $cartBadge }}
            @endisset
        </div>
    </header>

    <main class="mx-auto max-w-lg px-4 py-4 pb-32">
        {{ $slot }}
    </main>
</body>
</html>
