<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta name="theme-color" content="#0b1220">
    <link rel="manifest" href="/manifest.json">
    <title>{{ $title ?? 'Kasir POS' }}</title>
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/localforage@1.10.0/dist/localforage.min.js"></script>
</head>
<body class="bg-slate-100 text-slate-900 antialiased">
@auth
    <div
        x-data="{ sidebarOpen: window.innerWidth >= 1024, isDesktop: window.innerWidth >= 1024 }"
        @resize.window="isDesktop = window.innerWidth >= 1024"
        class="min-h-screen"
    >
        <div
            class="fixed inset-0 z-30 bg-slate-900/40 lg:hidden"
            x-show="sidebarOpen && !isDesktop"
            x-transition.opacity
            @click="sidebarOpen = false"
        ></div>

        <aside
            class="fixed inset-y-0 left-0 z-40 w-72 border-r border-white/10 bg-slate-950 text-slate-200 transition-transform duration-200"
            :class="sidebarOpen ? 'translate-x-0' : '-translate-x-full'"
        >
            <div class="flex items-center justify-between border-b border-white/10 px-4 py-4">
                <div x-show="sidebarOpen" class="min-w-0">
                    <p class="truncate text-sm font-semibold text-white">Kasir POS</p>
                    <p class="truncate text-xs text-slate-400">{{ auth()->user()->outlet?->name }}</p>
                </div>
                <button class="rounded-lg border border-white/10 p-2 hover:bg-white/5" @click="sidebarOpen = !sidebarOpen">
                    <svg class="h-4 w-4" viewBox="0 0 24 24" fill="none" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"/>
                    </svg>
                </button>
            </div>

            <nav class="space-y-1 p-3 text-sm">
                <a href="{{ route('pos.index') }}" class="side-link">POS</a>
                <a href="{{ route('orders.index') }}" class="side-link">Orders</a>
                <a href="{{ route('shifts.index') }}" class="side-link">Shifts</a>
                @if(in_array(auth()->user()->role, ['owner', 'admin'], true))
                    <a href="{{ route('reports.index') }}" class="side-link">Reports</a>
                    <a href="{{ route('kds.index') }}" class="side-link">Kitchen Display</a>
                    <a href="{{ route('settings.index') }}" class="side-link">Settings</a>
                    <a href="{{ route('offline-queue.index') }}" class="side-link">Offline Queue</a>
                    <p class="px-3 pt-3 text-[11px] font-semibold uppercase tracking-wide text-slate-500">Master Data</p>
                    <a href="{{ route('master.categories.index') }}" class="side-link">Kategori</a>
                    <a href="{{ route('master.products.index') }}" class="side-link">Produk/Menu</a>
                    <a href="{{ route('master.tables.index') }}" class="side-link">Meja (Self Order)</a>
                @endif
            </nav>

            <div class="absolute bottom-0 w-full border-t border-white/10 p-3">
                <p class="mb-2 px-2 text-xs text-slate-400">Role: {{ auth()->user()->role }}</p>
                <form method="POST" action="{{ route('logout') }}">
                    @csrf
                    <button type="submit" class="w-full rounded-lg bg-white/10 px-3 py-2 text-sm text-white hover:bg-white/20">Logout</button>
                </form>
            </div>
        </aside>

        <div class="min-h-screen transition-all duration-200" :class="sidebarOpen ? 'lg:pl-72' : 'lg:pl-0'">
            <header class="sticky top-0 z-20 border-b border-slate-200/70 bg-white/85 backdrop-blur">
                <div class="flex items-center justify-between px-4 py-3">
                    <div class="flex items-center gap-2">
                        <button class="rounded-lg border border-slate-200 p-2" @click="sidebarOpen = !sidebarOpen">
                            <svg class="h-4 w-4" viewBox="0 0 24 24" fill="none" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"/>
                            </svg>
                        </button>
                        <h1 class="text-sm font-semibold text-slate-800">{{ $title ?? 'Dashboard' }}</h1>
                    </div>
                    <p class="text-xs text-slate-500">{{ now()->format('d M Y H:i') }}</p>
                </div>
            </header>

            <main class="p-4 md:p-6">
                @if (session('success'))
                    <div class="mb-4 rounded-xl border border-emerald-200 bg-emerald-50 px-3 py-2 text-sm text-emerald-700">
                        {{ session('success') }}
                    </div>
                @endif
                @if ($errors->any())
                    <div class="mb-4 rounded-xl border border-rose-200 bg-rose-50 px-3 py-2 text-sm text-rose-700">
                        {{ $errors->first() }}
                    </div>
                @endif
                {{ $slot }}
            </main>
        </div>
    </div>
@else
    <main class="mx-auto max-w-7xl px-4 py-6">
        @if ($errors->any())
            <div class="mb-4 rounded-xl border border-rose-200 bg-rose-50 px-3 py-2 text-sm text-rose-700">
                {{ $errors->first() }}
            </div>
        @endif
        {{ $slot }}
    </main>
@endauth
</body>
</html>
