const store = localforage.createInstance({
    name: 'kasir-pos',
    storeName: 'offline_orders',
});

export const offlineQueue = {
    async enqueue(payload) {
        const id = payload.client_order_id || crypto.randomUUID();
        await store.setItem(id, {
            id,
            payload,
            created_at: new Date().toISOString(),
        });
    },
    async all() {
        const rows = [];
        await store.iterate((value) => rows.push(value));
        return rows;
    },
    async count() {
        return store.length();
    },
    async clear() {
        await store.clear();
    },
    async remove(id) {
        await store.removeItem(id);
    },
};
