<?php

namespace Database\Seeders;

use App\Models\Category;
use App\Models\Outlet;
use App\Models\Product;
use App\Models\ProductAddon;
use App\Models\ProductVariant;
use App\Models\Register;
use App\Models\Table;
use App\Models\User;
use App\Models\VariantOption;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class DemoSeeder extends Seeder
{
    public function run(): void
    {
        $outlet = Outlet::query()->create([
            'name' => 'KASIR DEMO FNB',
            'address' => 'Jl. Demo No. 1',
            'timezone' => 'Asia/Jakarta',
            'tax_percent' => 11,
            'service_percent' => 5,
            'receipt_header' => 'Terima kasih telah berbelanja',
            'receipt_footer' => 'Follow Instagram @kasirdemo',
        ]);

        $register = Register::query()->create([
            'outlet_id' => $outlet->id,
            'name' => 'Kasir 1',
        ]);

        $owner = User::query()->create([
            'name' => 'Owner Demo',
            'email' => 'owner@kasir.test',
            'role' => 'owner',
            'outlet_id' => $outlet->id,
            'password' => Hash::make('password'),
        ]);

        User::query()->create([
            'name' => 'Admin Demo',
            'email' => 'admin@kasir.test',
            'role' => 'admin',
            'outlet_id' => $outlet->id,
            'password' => Hash::make('password'),
        ]);

        User::query()->create([
            'name' => 'Kasir Demo',
            'email' => 'cashier@kasir.test',
            'role' => 'cashier',
            'outlet_id' => $outlet->id,
            'password' => Hash::make('password'),
        ]);

        $kopi = Category::query()->create(['outlet_id' => $outlet->id, 'name' => 'Coffee', 'sort_order' => 1]);
        $makanan = Category::query()->create(['outlet_id' => $outlet->id, 'name' => 'Ayam Geprek', 'sort_order' => 2]);
        $snack = Category::query()->create(['outlet_id' => $outlet->id, 'name' => 'Snack', 'sort_order' => 3]);

        $latte = Product::query()->create([
            'outlet_id' => $outlet->id,
            'category_id' => $kopi->id,
            'name' => 'Caffe Latte',
            'sku' => 'COF-LATTE',
            'base_price' => 22000,
            'cost' => 9000,
            'is_active' => true,
        ]);

        $sizeVariant = ProductVariant::query()->create([
            'product_id' => $latte->id,
            'name' => 'Size',
            'is_required' => true,
            'max_selection' => 1,
            'sort_order' => 1,
        ]);

        VariantOption::query()->create(['product_variant_id' => $sizeVariant->id, 'name' => 'Small', 'price_delta' => 0, 'sort_order' => 1]);
        VariantOption::query()->create(['product_variant_id' => $sizeVariant->id, 'name' => 'Medium', 'price_delta' => 3000, 'sort_order' => 2]);
        VariantOption::query()->create(['product_variant_id' => $sizeVariant->id, 'name' => 'Large', 'price_delta' => 6000, 'sort_order' => 3]);

        ProductAddon::query()->create(['product_id' => $latte->id, 'name' => 'Extra Shot', 'price' => 5000, 'sort_order' => 1]);
        ProductAddon::query()->create(['product_id' => $latte->id, 'name' => 'Oat Milk', 'price' => 7000, 'sort_order' => 2]);

        Product::query()->create([
            'outlet_id' => $outlet->id,
            'category_id' => $makanan->id,
            'name' => 'Ayam Geprek Level 3',
            'sku' => 'FOOD-GEPREK-3',
            'base_price' => 25000,
            'cost' => 12000,
            'is_active' => true,
        ]);

        Product::query()->create([
            'outlet_id' => $outlet->id,
            'category_id' => $snack->id,
            'name' => 'Kentang Goreng',
            'sku' => 'SNK-FRIES',
            'base_price' => 18000,
            'cost' => 7000,
            'is_active' => true,
        ]);

        foreach (range(1, 5) as $i) {
            Table::query()->create([
                'outlet_id' => $outlet->id,
                'name'      => "Meja {$i}",
                'qr_token'  => Table::generateToken(),
                'is_active' => true,
            ]);
        }
    }
}
