<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('orders', function (Blueprint $table) {
            $table->string('kitchen_status')->default('NEW')->index()->after('status');
            $table->unsignedBigInteger('refund_total')->default(0)->after('total');
            $table->timestamp('refunded_at')->nullable()->after('paid_at');
            $table->text('refund_reason')->nullable()->after('refunded_at');
        });

        Schema::table('payments', function (Blueprint $table) {
            $table->string('kind')->default('PAYMENT')->index()->after('order_id');
        });
    }

    public function down(): void
    {
        Schema::table('payments', function (Blueprint $table) {
            $table->dropColumn('kind');
        });

        Schema::table('orders', function (Blueprint $table) {
            $table->dropColumn(['kitchen_status', 'refund_total', 'refunded_at', 'refund_reason']);
        });
    }
};
