<?php

namespace App\Providers;

use App\Printing\BrowserPrintProvider;
use App\Printing\PrintProvider;
use Illuminate\Support\Facades\Gate;
use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        $this->app->bind(PrintProvider::class, BrowserPrintProvider::class);
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        Gate::define('manage-reports', fn ($user) => in_array($user->role, ['owner', 'admin'], true));
        Gate::define('manage-settings', fn ($user) => in_array($user->role, ['owner', 'admin'], true));
        Gate::define('void-order', fn ($user) => in_array($user->role, ['owner', 'admin'], true));
    }
}
