<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Support\Str;

class Table extends Model
{
    protected $fillable = [
        'outlet_id',
        'name',
        'qr_token',
        'is_active',
    ];

    protected $casts = [
        'is_active' => 'boolean',
    ];

    public function outlet(): BelongsTo
    {
        return $this->belongsTo(Outlet::class);
    }

    public static function generateToken(): string
    {
        return Str::random(32);
    }

    public function getMenuUrlAttribute(): string
    {
        return url("/menu/{$this->qr_token}");
    }
}
