<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Outlet extends Model
{
    protected $fillable = [
        'name',
        'address',
        'timezone',
        'tax_percent',
        'service_percent',
        'receipt_header',
        'receipt_footer',
    ];

    public function registers(): HasMany
    {
        return $this->hasMany(Register::class);
    }
}
