<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class OrderItem extends Model
{
    protected $fillable = [
        'order_id',
        'product_id',
        'name_snapshot',
        'base_price',
        'qty',
        'note',
        'variant_snapshot',
        'addons_snapshot',
        'line_total',
    ];

    protected function casts(): array
    {
        return [
            'variant_snapshot' => 'array',
            'addons_snapshot' => 'array',
        ];
    }

    public function order(): BelongsTo
    {
        return $this->belongsTo(Order::class);
    }
}
