<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Order extends Model
{
    protected $fillable = [
        'client_order_id',
        'outlet_id',
        'register_id',
        'user_id',
        'status',
        'kitchen_status',
        'order_type',
        'source',
        'table_number',
        'subtotal',
        'discount',
        'tax',
        'service',
        'total',
        'refund_total',
        'receipt_number',
        'paid_at',
        'refunded_at',
        'refund_reason',
        'synced_at',
        'client_created_at',
    ];

    protected function casts(): array
    {
        return [
            'paid_at' => 'datetime',
            'refunded_at' => 'datetime',
            'synced_at' => 'datetime',
            'client_created_at' => 'datetime',
        ];
    }

    public function items(): HasMany
    {
        return $this->hasMany(OrderItem::class);
    }

    public function payments(): HasMany
    {
        return $this->hasMany(Payment::class);
    }

    public function outlet(): BelongsTo
    {
        return $this->belongsTo(Outlet::class);
    }
}
