<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class VariantOptionRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'name' => ['required', 'string', 'max:120'],
            'price_delta' => ['required', 'integer', 'min:-1000000', 'max:1000000'],
            'sort_order' => ['nullable', 'integer', 'min:0'],
        ];
    }
}
