<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class VariantGroupRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'name' => ['required', 'string', 'max:120'],
            'is_required' => ['nullable', 'boolean'],
            'max_selection' => ['nullable', 'integer', 'min:1', 'max:10'],
            'sort_order' => ['nullable', 'integer', 'min:0'],
        ];
    }
}
