<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UpdateSettingsRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'name' => ['required', 'string', 'max:120'],
            'address' => ['nullable', 'string'],
            'timezone' => ['required', 'string', 'max:64'],
            'tax_percent' => ['required', 'integer', 'min:0', 'max:100'],
            'service_percent' => ['required', 'integer', 'min:0', 'max:100'],
            'receipt_header' => ['nullable', 'string'],
            'receipt_footer' => ['nullable', 'string'],
        ];
    }
}
