<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class SyncOrdersRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'orders' => ['required', 'array', 'min:1'],
            'orders.*.client_order_id' => ['required', 'uuid'],
            'orders.*.register_id' => ['nullable', 'exists:registers,id'],
            'orders.*.order_type' => ['required', Rule::in(['dine-in', 'takeaway', 'delivery'])],
            'orders.*.table_number' => ['nullable', 'string', 'max:20'],
            'orders.*.discount' => ['nullable', 'integer', 'min:0'],
            'orders.*.client_created_at' => ['nullable', 'date'],
            'orders.*.items' => ['required', 'array', 'min:1'],
            'orders.*.items.*.product_id' => ['required', 'exists:products,id'],
            'orders.*.items.*.qty' => ['required', 'integer', 'min:1'],
            'orders.*.items.*.note' => ['nullable', 'string', 'max:500'],
            'orders.*.items.*.variant_option_id' => ['nullable', 'exists:variant_options,id'],
            'orders.*.items.*.addon_ids' => ['nullable', 'array'],
            'orders.*.items.*.addon_ids.*' => ['integer', 'exists:product_addons,id'],
            'orders.*.payments' => ['required', 'array', 'min:1'],
            'orders.*.payments.*.method' => ['required', Rule::in(['CASH', 'QRIS', 'DEBIT'])],
            'orders.*.payments.*.amount' => ['required', 'integer', 'min:1'],
            'orders.*.payments.*.reference' => ['nullable', 'string', 'max:120'],
        ];
    }
}
