<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class CustomerOrderRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'order_type'              => ['nullable', 'in:dine-in,takeaway'],
            'customer_name'           => ['nullable', 'string', 'max:100'],
            'items'                   => ['required', 'array', 'min:1'],
            'items.*.product_id'      => ['required', 'integer', 'exists:products,id'],
            'items.*.qty'             => ['required', 'integer', 'min:1'],
            'items.*.note'            => ['nullable', 'string', 'max:255'],
            'items.*.variant_option_id' => ['nullable', 'integer', 'exists:variant_options,id'],
            'items.*.addon_ids'       => ['nullable', 'array'],
            'items.*.addon_ids.*'     => ['integer', 'exists:product_addons,id'],
        ];
    }
}
