<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class CashMovementRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'shift_id' => ['required', 'exists:shifts,id'],
            'type' => ['required', Rule::in(['IN', 'OUT'])],
            'amount' => ['required', 'integer', 'min:1'],
            'note' => ['nullable', 'string', 'max:250'],
        ];
    }
}
