<?php

namespace App\Http\Controllers;

use App\Models\Table;
use Illuminate\Http\Request;

class TableController extends Controller
{
    public function index()
    {
        $outletId = (int) auth()->user()->outlet_id;

        $tables = Table::query()
            ->where('outlet_id', $outletId)
            ->orderBy('name')
            ->get();

        return view('master.tables.index', compact('tables'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => ['required', 'string', 'max:100'],
        ]);

        $outletId = (int) auth()->user()->outlet_id;

        Table::query()->create([
            'outlet_id' => $outletId,
            'name'      => $request->input('name'),
            'qr_token'  => Table::generateToken(),
            'is_active' => true,
        ]);

        return back()->with('success', 'Meja berhasil ditambahkan.');
    }

    public function update(Request $request, Table $table)
    {
        $this->authorizeTable($table);

        $request->validate([
            'name'      => ['required', 'string', 'max:100'],
            'is_active' => ['boolean'],
        ]);

        $table->update([
            'name'      => $request->input('name'),
            'is_active' => $request->boolean('is_active', true),
        ]);

        return back()->with('success', 'Meja diperbarui.');
    }

    public function destroy(Table $table)
    {
        $this->authorizeTable($table);
        $table->delete();

        return back()->with('success', 'Meja dihapus.');
    }

    private function authorizeTable(Table $table): void
    {
        abort_if($table->outlet_id !== (int) auth()->user()->outlet_id, 403);
    }
}
