<?php

namespace App\Http\Controllers;

use App\Http\Requests\UpdateSettingsRequest;
use Illuminate\Http\RedirectResponse;
use Illuminate\View\View;

class SettingController extends Controller
{
    public function index(): View
    {
        $outlet = auth()->user()->outlet;

        return view('settings.index', compact('outlet'));
    }

    public function update(UpdateSettingsRequest $request): RedirectResponse
    {
        $request->user()->outlet->update($request->validated());

        return back()->with('success', 'Pengaturan outlet diperbarui.');
    }
}
