<?php

namespace App\Http\Controllers;

use App\Models\Order;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\View\View;

class ReportController extends Controller
{
    public function index(Request $request): View
    {
        $user = $request->user();
        $from = $request->input('from', now()->toDateString());
        $to = $request->input('to', now()->toDateString());

        $query = Order::query()
            ->where('outlet_id', $user->outlet_id)
            ->where('status', 'PAID')
            ->whereBetween(DB::raw('DATE(created_at)'), [$from, $to]);

        $summary = [
            'total_sales' => (int) $query->sum('total'),
            'total_tax' => (int) $query->sum('tax'),
            'total_service' => (int) $query->sum('service'),
            'net_sales' => (int) $query->sum(DB::raw('total - tax - service')),
            'count_orders' => (int) $query->count(),
        ];

        $today = now()->toDateString();
        $salesToday = (int) Order::query()
            ->where('outlet_id', $user->outlet_id)
            ->whereDate('created_at', $today)
            ->where('status', 'PAID')
            ->sum('total');

        $transactionsToday = (int) Order::query()
            ->where('outlet_id', $user->outlet_id)
            ->whereDate('created_at', $today)
            ->where('status', 'PAID')
            ->count();

        $topProducts = DB::table('order_items')
            ->join('orders', 'orders.id', '=', 'order_items.order_id')
            ->select('order_items.name_snapshot', DB::raw('SUM(order_items.qty) as qty'))
            ->where('orders.outlet_id', $user->outlet_id)
            ->whereDate('orders.created_at', $today)
            ->where('orders.status', 'PAID')
            ->groupBy('order_items.name_snapshot')
            ->orderByDesc('qty')
            ->limit(5)
            ->get();

        return view('reports.index', compact(
            'summary',
            'from',
            'to',
            'salesToday',
            'transactionsToday',
            'topProducts'
        ));
    }
}
