<?php

namespace App\Http\Controllers;

use App\Http\Requests\UpdateKitchenStatusRequest;
use App\Models\Order;
use App\Services\OrderService;
use Illuminate\Http\RedirectResponse;
use Illuminate\View\View;

class KdsController extends Controller
{
    public function index(): View
    {
        $orders = Order::query()
            ->with(['items'])
            ->where('outlet_id', auth()->user()->outlet_id)
            ->whereIn('status', ['PAID'])
            ->whereIn('kitchen_status', ['NEW', 'PREPARING', 'READY'])
            ->latest()
            ->limit(80)
            ->get();

        return view('kds.index', compact('orders'));
    }

    public function update(UpdateKitchenStatusRequest $request, Order $order, OrderService $service): RedirectResponse
    {
        abort_if((int) $order->outlet_id !== (int) $request->user()->outlet_id, 403);
        $service->updateKitchenStatus($order, $request->user()->id, $request->validated('kitchen_status'));

        return back()->with('success', 'Status dapur diperbarui.');
    }
}
