# Kasir POS (Laravel 12 + Blade + Alpine + PWA)

MVP aplikasi kasir web-based untuk F&B (coffeeshop, ayam geprek, restoran) dengan arsitektur modular, role-based access, shift kas, dan offline-first sync.

## Stack

- Laravel 12
- PHP 8.2+
- MySQL 8
- TailwindCSS
- Blade + Alpine.js
- Sanctum (API token untuk device PWA)
- localForage (IndexedDB queue offline)

## Fitur Utama (MVP)

- Auth login email/password
- RBAC role `owner`, `admin`, `cashier` via middleware + Gates
- Master data: outlet, register, kategori, produk, varian, add-on
- CRUD master data via sidebar (owner/admin): kategori + produk/menu + varian + add-on
- Upload foto produk (file image) atau URL gambar
- POS screen cepat: kategori/search, grid produk, cart, hold/clear/pay
- Pembayaran: `CASH`, `QRIS`, `DEBIT` + split payment multi-metode
- Status order: `DRAFT`, `PAID`, `VOIDED`, `REFUNDED`
- Refund parsial/full (owner/admin) tercatat ke payment ledger
- Kitchen Display System (`/kds`) dengan status `NEW`, `PREPARING`, `READY`, `SERVED`
- Shift kas: buka shift, cash in/out, tutup shift + variance
- Reporting ringkas: sales today, tx today, top product, laporan range
- PWA: manifest + service worker
- Offline-first:
  - saat offline, order paid masuk queue IndexedDB (`pending_sync`)
  - saat online, kirim batch ke `/api/sync/orders`
  - idempotent dengan `client_order_id` UUID
- Offline Queue page untuk admin
- Baseline receipt print + `PrintProvider` hook untuk integrasi printer berikutnya
- Thermal receipt page (`/orders/{id}/print`) dengan format 80mm browser print

## Instalasi

1. Clone / masuk folder project.
2. Copy env:

```bash
cp .env.example .env
```

3. Install dependency PHP:

```bash
composer install
```

4. Generate key app:

```bash
php artisan key:generate
```

5. Setup database MySQL di `.env`.
6. Migrate + seed demo:

```bash
php artisan migrate --seed
```

7. Install frontend dependency:

```bash
npm install
npm run build
```

8. Jalankan app:

```bash
php artisan serve
```

## Akun Demo

- Owner: `owner@kasir.test` / `password`
- Admin: `admin@kasir.test` / `password`
- Cashier: `cashier@kasir.test` / `password`

## Struktur Folder Inti

- `app/Http/Controllers` controller web + API
- `app/Http/Requests` form validation
- `app/Services/OrderService.php` create order atomic + idempotent
- `app/Services/ShiftService.php` kalkulasi expected cash
- `app/Printing` interface print provider
- `app/Models` model domain POS
- `database/migrations` schema POS lengkap
- `database/seeders/DemoSeeder.php` seed data demo
- `resources/views` Blade pages (`/pos`, `/orders`, `/shifts`, `/reports`, `/kds`, `/settings`, `/offline-queue`)
- `resources/views/master` halaman CRUD master data menu
- `resources/js/offlineQueue.js` helper IndexedDB/localForage
- `public/sw.js` service worker
- `public/manifest.json` PWA manifest
- `routes/web.php` halaman web
- `routes/api.php` endpoint sync/token
- `tests/Feature/CreatePaidOrderTest.php`
- `tests/Feature/SyncOfflineBatchTest.php`

## Endpoint Sync Offline

### Auth token device

`POST /api/auth/token`

Body:

```json
{
  "email": "cashier@kasir.test",
  "password": "password",
  "device_name": "kasir-tablet-1"
}
```

Response:

```json
{
  "token": "1|xxxxx"
}
```

### Batch sync order

`POST /api/sync/orders` (Bearer token Sanctum)

Contoh payload:

```json
{
  "orders": [
    {
      "client_order_id": "f7a65644-c95e-4b8f-af23-0cb53ce7f8e4",
      "register_id": 1,
      "order_type": "takeaway",
      "table_number": null,
      "discount": 0,
      "client_created_at": "2026-02-22T10:15:00+07:00",
      "items": [
        {
          "product_id": 1,
          "qty": 2,
          "note": "less ice",
          "variant_option_id": 2,
          "addon_ids": [1]
        }
      ],
      "payments": [
        {
          "method": "QRIS",
          "amount": 55000,
          "reference": "TRX123"
        }
      ]
    }
  ]
}
```

Contoh response:

```json
{
  "data": [
    {
      "client_order_id": "f7a65644-c95e-4b8f-af23-0cb53ce7f8e4",
      "server_order_id": 27,
      "receipt_number": "INV-20260222-0027",
      "status": "PAID"
    }
  ]
}
```

## Testing

Jalankan:

```bash
php artisan test
```

Test tersedia:

- create paid order online
- sync offline batch + idempotency `client_order_id`
- split payment + refund + update kitchen status

## Thermal Printer

- Dari detail order, klik `Print Thermal Receipt`.
- Halaman print menggunakan ukuran kertas thermal 80mm (`@page size: 80mm auto`).
- Set printer ke thermal 80mm di browser print dialog, lalu cetak.

## Catatan Penting

- Seluruh uang disimpan integer (rupiah).
- Index DB penting sudah ditambahkan di migration order/payment/item.
- Untuk environment local ini, pastikan PHP 8.2+ tersedia karena Laravel 12 mensyaratkan itu.
